﻿--[[

-- Atlas Data (Traditional Chinese)
-- Translated and maintained by Arith Hsu
-- arithmandarjp at yahoo.co.jp
-- Special thanks for Alfred and his website "Alfred's WoW Treasure BOX"
-- http://statue.sayya.org/wowdb/index.php
--
-- Last Updated: 8/09/2007

--]]
if (GetLocale() == 	"zhTW") then

--[[
loottables.en.lua
This file assigns a title to every loot table.  The primary use of this table
is in the search function, as when iterating through the loot tables there is no
inherant title to the loot table, given the origins of the mod as an Atlas plugin.
]]

--Invoke libraries
local BabbleTrade=AceLibrary("Babble-Tradeskill-2.2");
local BabbleFaction = AceLibrary("Babble-Faction-2.2");

--Table of loot titles
--AtlasLoot_TableNames = {};

  --Keys
    AtlasLoot_TableNames["OldKeys"][1] =  "鑰匙";
    AtlasLoot_TableNames["BCKeys"][1] =  "鑰匙";
  --Auch: Auchenai Crypts
    AtlasLoot_TableNames["AuchCryptsShirrak"][1] =  "死亡看守者辛瑞克";
    AtlasLoot_TableNames["AuchCryptsShirrakHEROIC"][1] =  "死亡看守者辛瑞克 (英雄)";
    AtlasLoot_TableNames["AuchCryptsExarch"][1] =  "主教瑪拉達爾";
    AtlasLoot_TableNames["AuchCryptsExarchHEROIC"][1] =  "主教瑪拉達爾  (英雄)";
    AtlasLoot_TableNames["AuchCryptsAvatar"][1] =  "馬丁瑞德的化身";
    AtlasLoot_TableNames["AuchCryptsTrash"][1] =  "小怪 (奧奇奈地穴)";
  --Auch: Mana-Tombs
    AtlasLoot_TableNames["AuchManaPandemonius"][1] =  "班提蒙尼厄斯";
    AtlasLoot_TableNames["AuchManaPandemoniusHEROIC"][1] =  "班提蒙尼厄斯 (英雄)";
    AtlasLoot_TableNames["AuchManaTavarok"][1] =  "塔瓦洛克";
    AtlasLoot_TableNames["AuchManaTavarokHEROIC"][1] =  "塔瓦洛克 (英雄)";
    AtlasLoot_TableNames["AuchManaNexusPrince"][1] =  "奈薩斯王子薩法爾";
    AtlasLoot_TableNames["AuchManaNexusPrinceHEROIC"][1] =  "奈薩斯王子薩法爾 (英雄)";
    AtlasLoot_TableNames["AuchManaYor"][1] =  "約兒";
    AtlasLoot_TableNames["AuchManaTrash"][1] =  "小怪 (法力墓地)";
  --Auch: Sethekk Halls
    AtlasLoot_TableNames["AuchSethekkDarkweaver"][1] =  "暗法師希斯";
    AtlasLoot_TableNames["AuchSethekkDarkweaverHEROIC"][1] =  "暗法師希斯  (英雄)";
    AtlasLoot_TableNames["AuchSethekkTalonKing"][1] =  "鷹王伊奇斯";
    AtlasLoot_TableNames["AuchSethekkTalonKingHEROIC"][1] =  "鷹王伊奇斯 (英雄)";
    AtlasLoot_TableNames["AuchSethekkRavenGod"][1] =  "安祖";
    AtlasLoot_TableNames["AuchSethekkTrash"][1] =  "小怪 (塞司克大廳)";
  --Auch: Shadow Labyrinth
    AtlasLoot_TableNames["AuchShadowHellmaw"][1] =  "海爾瑪大使";
    AtlasLoot_TableNames["AuchShadowHellmawHEROIC"][1] =  "海爾瑪大使 (英雄)";
    AtlasLoot_TableNames["AuchShadowBlackheart"][1] =  "激勵者布萊克哈特";
    AtlasLoot_TableNames["AuchShadowBlackheartHEROIC"][1] =  "激勵者布萊克哈特 (英雄)";
    AtlasLoot_TableNames["AuchShadowGrandmaster"][1] =  "領導者瓦皮歐";
    AtlasLoot_TableNames["AuchShadowGrandmasterHEROIC"][1] =  "領導者瓦皮歐 (英雄)";
    AtlasLoot_TableNames["AuchShadowMurmur"][1] =  "莫爾墨";
    AtlasLoot_TableNames["AuchShadowMurmurHEROIC"][1] =  "莫爾墨 (英雄)";
    AtlasLoot_TableNames["AuchShadowTrash"][1] =  "小怪 (暗影迷宮)";
  --Blackfathom Deeps
    AtlasLoot_TableNames["BFDGhamoora"][1] =  "加摩拉";
    AtlasLoot_TableNames["BFDLadySarevess"][1] =  "薩利維絲";
    AtlasLoot_TableNames["BFDGelihast"][1] =  "格里哈斯特";
    AtlasLoot_TableNames["BFDBaronAquanis"][1] =  "阿奎尼斯男爵";
    AtlasLoot_TableNames["BFDTwilightLordKelris"][1] =  "夢遊者克爾里斯";
    AtlasLoot_TableNames["BFDOldSerrakis"][1] =  "瑟拉吉斯";
    AtlasLoot_TableNames["BFDAkumai"][1] =  "阿庫麥爾";
    AtlasLoot_TableNames["BFDQuestItems"][1] =  "任務物品 (黑暗深淵)";
    AtlasLoot_TableNames["BFDTrash"][1] =  "小怪 (黑暗深淵)";
  --Blackrock Mountain
    AtlasLoot_TableNames["BRMScarshieldQuartermaster"][1] =  "裂盾軍需官";
  --Blackrock Depths
    AtlasLoot_TableNames["BRDPyron"][1] =  "征服者派隆";
    AtlasLoot_TableNames["BRDLordRoccor"][1] =  "洛考爾";
    AtlasLoot_TableNames["BRDHighInterrogatorGerstahn"][1] =  "審訊官格斯塔恩";
    AtlasLoot_TableNames["BRDArena"][1] =  "競技場";
    AtlasLoot_TableNames["BRDTheldren"][1] =  "瑟爾倫";
    AtlasLoot_TableNames["BRDHoundmaster"][1] =  "馴犬者格雷布瑪爾";
    AtlasLoot_TableNames["BRDForgewright"][1] =  "弗蘭克羅恩·鑄鐵的雕像";
    AtlasLoot_TableNames["BRDPyromantLoregrain"][1] =  "控火師羅格雷恩";
    AtlasLoot_TableNames["BRDTheVault"][1] =  "寶窟";
    AtlasLoot_TableNames["BRDWarderStilgiss"][1] =  "典獄官斯迪爾基斯";
    AtlasLoot_TableNames["BRDVerek"][1] =  "維雷克";
    AtlasLoot_TableNames["BRDFineousDarkvire"][1] =  "弗諾斯·達克維爾";
    AtlasLoot_TableNames["BRDLordIncendius"][1] =  "伊森迪奧斯";
    AtlasLoot_TableNames["BRDBaelGar"][1] =  "貝爾加";
    AtlasLoot_TableNames["BRDGeneralAngerforge"][1] =  "安格弗將軍";
    AtlasLoot_TableNames["BRDGolemLordArgelmach"][1] =  "傀儡統帥阿格曼奇";
    AtlasLoot_TableNames["BRDGuzzler"][1] =  "黑鐵酒吧";
    AtlasLoot_TableNames["BRDFlamelash"][1] =  "弗萊拉斯大使";
    AtlasLoot_TableNames["BRDPanzor"][1] =  "無敵的潘佐爾 (稀有)";
    AtlasLoot_TableNames["BRDTomb"][1] =  "召喚者之墓";
    AtlasLoot_TableNames["BRDLyceum"][1] =  "暗爐持火者";
    AtlasLoot_TableNames["BRDMagmus"][1] =  "瑪格姆斯";
    AtlasLoot_TableNames["BRDPrincess"][1] =  "茉艾拉·銅鬚公主";
    AtlasLoot_TableNames["BRDImperatorDagranThaurissan"][1] =  "達格蘭·索瑞森大帝";
    AtlasLoot_TableNames["BRDBSPlans"][1] =  "鍛造圖樣 (黑石深淵)";
    AtlasLoot_TableNames["BRDTrash"][1] =  "小怪 (黑石深淵)";
  --Lower Blackrock Spire
    AtlasLoot_TableNames["LBRSQuestItems"][1] =  "黑石塔下層任務物品";
    AtlasLoot_TableNames["LBRSSpirestoneButcher"][1] =  "尖石屠夫 (稀有)";
    AtlasLoot_TableNames["LBRSOmokk"][1] =  "歐莫克大王";
    AtlasLoot_TableNames["LBRSSpirestoneLord"][1] =  "尖石統帥 (稀有)";
    AtlasLoot_TableNames["LBRSLordMagus"][1] =  "尖石首席法師 (稀有)";
    AtlasLoot_TableNames["LBRSVosh"][1] =  "暗影獵手沃許加斯";
    AtlasLoot_TableNames["LBRSVoone"][1] =  "指揮官沃恩";
    AtlasLoot_TableNames["LBRSGrayhoof"][1] =  "莫爾·灰蹄 (召喚)";
    AtlasLoot_TableNames["LBRSGrimaxe"][1] =  "班諾克·巨斧 (稀有)";
    AtlasLoot_TableNames["LBRSSmolderweb"][1] =  "煙網蛛后";
    AtlasLoot_TableNames["LBRSCrystalFang"][1] =  "水晶之牙";
    AtlasLoot_TableNames["LBRSDoomhowl"][1] =  "烏洛克 (召喚)";
    AtlasLoot_TableNames["LBRSZigris"][1] =  "軍需官茲格雷斯";
    AtlasLoot_TableNames["LBRSHalycon"][1] =  "哈雷肯";
    AtlasLoot_TableNames["LBRSSlavener"][1] =  "奴役者基茲盧爾";
    AtlasLoot_TableNames["LBRSBashguud"][1] =  "霍克·巴什古德 (稀有)";
    AtlasLoot_TableNames["LBRSWyrmthalak"][1] =  "維姆薩拉克";
    AtlasLoot_TableNames["LBRSFelguard"][1] =  "燃燒地獄衛士 (稀有, 隨機)";
    AtlasLoot_TableNames["LBRSTrash"][1] =  "小怪 (黑下)";
  --Upper Blackrock Spire
    AtlasLoot_TableNames["UBRSEmberseer"][1] =  "烈焰衛士艾博希爾";
    AtlasLoot_TableNames["UBRSSolakar"][1] =  "索拉卡·火冠";
    AtlasLoot_TableNames["UBRSFLAME"][1] =  "烈焰之父";
    AtlasLoot_TableNames["UBRSRunewatcher"][1] =  "傑德";
    AtlasLoot_TableNames["UBRSAnvilcrack"][1] =  "古拉魯克";
    AtlasLoot_TableNames["UBRSRend"][1] =  "大酋長雷德·黑手";
    AtlasLoot_TableNames["UBRSGyth"][1] =  "蓋斯";
    AtlasLoot_TableNames["UBRSBeast"][1] =  "比斯巨獸";
    AtlasLoot_TableNames["UBRSValthalak"][1] =  "瓦薩拉克 (召喚)";
    AtlasLoot_TableNames["UBRSDrakkisath"][1] =  "達基薩斯將軍";
    AtlasLoot_TableNames["UBRSTrash"][1] =  "小怪 (黑上)";
  --The Black Temple
    AtlasLoot_TableNames["BTNajentus"][1] =  "高階督軍納珍塔斯";
    AtlasLoot_TableNames["BTSupremus"][1] =  "瑟普莫斯";
    AtlasLoot_TableNames["BTGorefiend"][1] =  "泰朗·血魔";
    AtlasLoot_TableNames["BTBloodboil"][1] =  "葛塔格·血沸";
    AtlasLoot_TableNames["BTAkama"][1] =  "阿卡瑪的鬼魂";
    AtlasLoot_TableNames["BTEssencofSouls"][1] =  "死靈精華";
    AtlasLoot_TableNames["BTShahraz"][1] =  "薩拉茲女士";
    AtlasLoot_TableNames["BTCouncil"][1] =  "伊利達瑞議事";
    AtlasLoot_TableNames["BTIllidanStormrage"][1] =  "伊利丹怒風";
    AtlasLoot_TableNames["BTTrash"][1] =  "小怪 (黑暗神廟)";
  --Blackwing Lair
    AtlasLoot_TableNames["BWLRazorgore"][1] =  "狂野的拉佐格爾";
    AtlasLoot_TableNames["BWLVaelastrasz"][1] =  "墮落的瓦拉斯塔茲";
    AtlasLoot_TableNames["BWLLashlayer"][1] =  "勒西雷爾";
    AtlasLoot_TableNames["BWLFiremaw"][1] =  "費爾默";
    AtlasLoot_TableNames["BWLEbonroc"][1] =  "埃博諾克";
    AtlasLoot_TableNames["BWLFlamegor"][1] =  "弗萊格爾";
    AtlasLoot_TableNames["BWLChromaggus"][1] =  "克洛瑪古斯";
    AtlasLoot_TableNames["BWLNefarian"][1] =  "奈法利安";
    AtlasLoot_TableNames["BWLTrashMobs"][1] =  "小怪 (黑翼)";
  --CFR: Serpentshrine Cavern
    AtlasLoot_TableNames["CFRSerpentHydross"][1] =  "不穩定者海卓司";
    AtlasLoot_TableNames["CFRSerpentKarathress"][1] =  "深淵之王卡拉薩瑞斯";
    AtlasLoot_TableNames["CFRSerpentMorogrim"][1] =  "莫洛葛利姆·潮行者";
    AtlasLoot_TableNames["CFRSerpentLeotheras"][1] =  "盲目者李奧薩拉斯";
    AtlasLoot_TableNames["CFRSerpentLurker"][1] =  "地底潛伏者";
    AtlasLoot_TableNames["CFRSerpentVashj"][1] =  "瓦許女士";
    AtlasLoot_TableNames["CFRSerpentTrash"][1] =  "小怪 (毒蛇神殿洞穴)";
  --CFR: Slave Pens
    AtlasLoot_TableNames["CFRSlaveMennu"][1] =  "背叛者曼紐";
    AtlasLoot_TableNames["CFRSlaveMennuHEROIC"][1] =  "背叛者曼紐 (英雄)";
    AtlasLoot_TableNames["CFRSlaveRokmar"][1] =  "爆破者洛克瑪";
    AtlasLoot_TableNames["CFRSlaveRokmarHEROIC"][1] =  "爆破者洛克瑪 (英雄)";
    AtlasLoot_TableNames["CFRSlaveQuagmirran"][1] =  "奎克米瑞";
    AtlasLoot_TableNames["CFRSlaveQuagmirranHEROIC"][1] =  "奎克米瑞 (英雄)";
  --CFR: The Steamvault
    AtlasLoot_TableNames["CFRSteamThespia"][1] =  "海法師希斯比亞";
    AtlasLoot_TableNames["CFRSteamThespiaHEROIC"][1] =  "海法師希斯比亞 (英雄)";
    AtlasLoot_TableNames["CFRSteamSteamrigger"][1] =  "米克吉勒·蒸氣操控者";
    AtlasLoot_TableNames["CFRSteamSteamriggerHEROIC"][1] =  "米克吉勒·蒸氣操控者 (英雄)";
    AtlasLoot_TableNames["CFRSteamWarlord"][1] =  "督軍卡利斯瑞";
    AtlasLoot_TableNames["CFRSteamWarlordHEROIC"][1] =  "督軍卡利斯瑞 (英雄)";
    AtlasLoot_TableNames["CFRSteamTrash"][1] =  "小怪 (蒸汽洞窟)";
  --CFR: The Underbog
    AtlasLoot_TableNames["CFRUnderHungarfen"][1] =  "飢餓之牙";
    AtlasLoot_TableNames["CFRUnderHungarfenHEROIC"][1] =  "飢餓之牙 (英雄)";
    AtlasLoot_TableNames["CFRUnderGhazan"][1] =  "高薩安";
    AtlasLoot_TableNames["CFRUnderGhazanHEROIC"][1] =  "高薩安 (英雄)";
    AtlasLoot_TableNames["CFRUnderSwamplord"][1] =  "沼澤王莫斯萊克";
    AtlasLoot_TableNames["CFRUnderSwamplordHEROIC"][1] =  "沼澤王莫斯萊克 (英雄)";
    AtlasLoot_TableNames["CFRUnderStalker"][1] =  "黑色捕獵者";
    AtlasLoot_TableNames["CFRUnderStalkerHEROIC"][1] =  "黑色捕獵者 (英雄)";
  --CoT: Old Hillsbrad Foothills
    AtlasLoot_TableNames["CoTHillsbradDrake"][1] =  "中尉崔克";
    AtlasLoot_TableNames["CoTHillsbradDrakeHEROIC"][1] =  "中尉崔克 (英雄)";
    AtlasLoot_TableNames["CoTHillsbradSkarloc"][1] =  "史卡拉克上尉";
    AtlasLoot_TableNames["CoTHillsbradSkarlocHEROIC"][1] =  "史卡拉克上尉 (英雄)";
    AtlasLoot_TableNames["CoTHillsbradHunter"][1] =  "伊波奇獵人";
    AtlasLoot_TableNames["CoTHillsbradHunterHEROIC"][1] =  "伊波奇獵人 (英雄)";
    AtlasLoot_TableNames["CoTHillsbradTrash"][1] =  "小怪 (時光之穴:希爾斯布萊德 )";
  --CoT: Black Morass
    AtlasLoot_TableNames["CoTMorassDeja"][1] =  "克洛諾斯領主迪賈";
    AtlasLoot_TableNames["CoTMorassDejaHEROIC"][1] =  "克洛諾斯領主迪賈 (英雄)";
    AtlasLoot_TableNames["CoTMorassTemporus"][1] =  "坦普拉斯";
    AtlasLoot_TableNames["CoTMorassTemporusHEROIC"][1] =  "坦普拉斯 (英雄)";
    AtlasLoot_TableNames["CoTMorassAeonus"][1] =  "艾奧那斯";
    AtlasLoot_TableNames["CoTMorassAeonusHEROIC"][1] =  "艾奧那斯 (英雄)";
    AtlasLoot_TableNames["CoTMorassTrash"][1] =  "小怪 (時光之穴:黑色沼澤)";
  --CoT: Hyjal Summit
    AtlasLoot_TableNames["MountHyjalWinterchill"][1] =  "瑞奇·寒冬";
    AtlasLoot_TableNames["MountHyjalAnetheron"][1] =  "安納斯隆";
    AtlasLoot_TableNames["MountHyjalKazrogal"][1] =  "卡斯羅高";
    AtlasLoot_TableNames["MountHyjalAzgalor"][1] =  "阿斯卡勒";
    AtlasLoot_TableNames["MountHyjalArchimonde"][1] =  "阿克蒙德";
  --The Deadmines
    AtlasLoot_TableNames["VCMarisaduPaige"][1] =  "瑪里莎·杜派格";
    AtlasLoot_TableNames["VCBrainwashedNoble"][1] =  "被洗腦的貴族";
    AtlasLoot_TableNames["VCForemanThistlenettle"][1] =  "工頭希斯耐特";
    AtlasLoot_TableNames["VCRhahkZor"][1] =  "拉克佐";
    AtlasLoot_TableNames["VCMinerJohnson"][1] =  "礦工約翰森 (稀有)";
    AtlasLoot_TableNames["VCSneed"][1] =  "斯尼德";
    AtlasLoot_TableNames["VCGilnid"][1] =  "基爾尼格";
    AtlasLoot_TableNames["VCCaptainGreenskin"][1] =  "綠皮隊長";
    AtlasLoot_TableNames["VCVanCleef"][1] =  "艾德溫·范克里夫";
    AtlasLoot_TableNames["VCMrSmite"][1] =  "重拳先生";
    AtlasLoot_TableNames["VCCookie"][1] =  "曲奇";
    AtlasLoot_TableNames["VCDefiasGunpowder"][1] =  "迪菲亞火藥";
  --Dire Maul East
    AtlasLoot_TableNames["DMEPusillin"][1] =  "普希林";
    AtlasLoot_TableNames["DMEZevrimThornhoof"][1] =  "瑟雷姆·刺蹄";
    AtlasLoot_TableNames["DMEHydro"][1] =  "海多斯博恩";
    AtlasLoot_TableNames["DMELethtendris"][1] =  "蕾瑟塔蒂絲";
    AtlasLoot_TableNames["DMEPimgib"][1] =  "匹姆吉布";
    AtlasLoot_TableNames["DMEAlzzin"][1] =  "奧茲恩";
    AtlasLoot_TableNames["DMEIsalien"][1] =  "依薩利恩";
    AtlasLoot_TableNames["DMETrash"][1] =  "小怪 (東厄運)";
    AtlasLoot_TableNames["DMBooks"][1] =  "厄運書籍";
  --Dire Maul North
    AtlasLoot_TableNames["DMNGuardMoldar"][1] =  "衛兵摩爾達";
    AtlasLoot_TableNames["DMNStomperKreeg"][1] =  "踐踏者克雷格";
    AtlasLoot_TableNames["DMNGuardFengus"][1] =  "衛兵芬古斯";
    AtlasLoot_TableNames["DMNThimblejack"][1] =  "諾特·希姆加克";
    AtlasLoot_TableNames["DMNGuardSlipkik"][1] =  "衛兵斯里基克";
    AtlasLoot_TableNames["DMNCaptainKromcrush"][1] =  "克羅卡斯";
    AtlasLoot_TableNames["DMNChoRush"][1] =  "觀察者克魯什";
    AtlasLoot_TableNames["DMNKingGordok"][1] =  "戈多克大王";
    AtlasLoot_TableNames["DMNTRIBUTERUN"][1] =  "北厄貢品箱";
  --Dire Maul West
    AtlasLoot_TableNames["DMWTendrisWarpwood"][1] =  "特迪斯·扭木";
    AtlasLoot_TableNames["DMWIllyannaRavenoak"][1] =  "伊琳娜·暗木";
    AtlasLoot_TableNames["DMWMagisterKalendris"][1] =  "卡雷迪斯鎮長";
    AtlasLoot_TableNames["DMWTsuzee"][1] =  "蘇斯";
    AtlasLoot_TableNames["DMWImmolthar"][1] =  "伊莫塔爾";
    AtlasLoot_TableNames["DMWHelnurath"][1] =  "赫爾努拉斯";
    AtlasLoot_TableNames["DMWPrinceTortheldrin"][1] =  "托塞德林王子";
    AtlasLoot_TableNames["DMWTrash"][1] =  "小怪 (西厄運)";
  --Gnomeregan
    AtlasLoot_TableNames["GnNamdoBizzfizzle"][1] =  "納姆杜";
    AtlasLoot_TableNames["GnTechbot"][1] =  "尖端機器人";
    AtlasLoot_TableNames["GnGrubbis"][1] =  "格魯比斯";
    AtlasLoot_TableNames["GnViscousFallout"][1] =  "粘性輻射塵";
    AtlasLoot_TableNames["GnElectrocutioner6000"][1] =  "電刑器6000型";
    AtlasLoot_TableNames["GnCrowdPummeler960"][1] =  "群體打擊者9-60";
    AtlasLoot_TableNames["GnDIAmbassador"][1] =  "黑鐵大師 (稀有)";
    AtlasLoot_TableNames["GnMekgineerThermaplugg"][1] =  "麥克尼爾·瑟瑪普拉格";
    AtlasLoot_TableNames["GnTrash"][1] =  "小怪 (諾姆瑞根)";
  --Gruul's Lair
    AtlasLoot_TableNames["GruulsLairHighKingMaulgar"][1] =  "大君王莫卡爾";
    AtlasLoot_TableNames["GruulGruul"][1] =  "弒龍者戈魯爾";
  --HC: Blood Furnace
    AtlasLoot_TableNames["HCFurnaceMaker"][1] =  "創造者";
    AtlasLoot_TableNames["HCFurnaceMakerHEROIC"][1] =  "創造者 (英雄)";
    AtlasLoot_TableNames["HCFurnaceBroggok"][1] =  "布洛克";
    AtlasLoot_TableNames["HCFurnaceBroggokHEROIC"][1] =  "布洛克 (英雄)";
    AtlasLoot_TableNames["HCFurnaceBreaker"][1] =  "破壞者·凱利丹";
    AtlasLoot_TableNames["HCFurnaceBreakerHEROIC"][1] =  "破壞者·凱利丹 (英雄)";
  --HC: Magtheridon's Lair
    AtlasLoot_TableNames["HCMagtheridon"][1] =  "麥格賽立頓";
  --HC: Ramparts
    AtlasLoot_TableNames["HCRampWatchkeeper"][1] =  "看護者卡爾古瑪";
    AtlasLoot_TableNames["HCRampWatchkeeperHEROIC"][1] =  "看護者卡爾古瑪 (英雄)";
    AtlasLoot_TableNames["HCRampOmor"][1] =  "無疤者歐瑪爾";
    AtlasLoot_TableNames["HCRampOmorHEROIC"][1] =  "無疤者歐瑪爾 (英雄)";
    AtlasLoot_TableNames["HCRampVazruden"][1] =  "維斯路登";
    AtlasLoot_TableNames["HCRampNazan"][1] =  "納桑";
    AtlasLoot_TableNames["HCRampFelIronChest"][1] =  "強化惡魔鐵箱";
    AtlasLoot_TableNames["HCRampFelIronChestHEROIC"][1] =  "強化惡魔鐵箱 (英雄)";
  --HC: Shattered Halls
    AtlasLoot_TableNames["HCHallsNethekurse"][1] =  "大術士·奈德克斯";
    AtlasLoot_TableNames["HCHallsNethekurseHEROIC"][1] =  "大術士·奈德克斯 (英雄)";
    AtlasLoot_TableNames["HCHallsPorung"][1] =  "血衛士波洛克 (英雄)";
    AtlasLoot_TableNames["HCHallsOmrogg"][1] =  "戰爭製造者·歐姆拉格";
    AtlasLoot_TableNames["HCHallsOmroggHEROIC"][1] =  "戰爭製造者·歐姆拉格 (英雄)";
    AtlasLoot_TableNames["HCHallsKargath"][1] =  "大酋長卡喀斯·刃拳";
    AtlasLoot_TableNames["HCHallsKargathHEROIC"][1] =  "大酋長卡喀斯·刃拳 (英雄)";
    AtlasLoot_TableNames["HCHallsTrash"][1] =  "小怪 (地域火:破碎大廳)";
  --Karazhan
    AtlasLoot_TableNames["KaraAttumen"][1] =  "獵人阿圖曼";
    AtlasLoot_TableNames["KaraNamed"][1] =  "動物之王";
    AtlasLoot_TableNames["KaraMoroes"][1] =  "摩洛";
    AtlasLoot_TableNames["KaraMaiden"][1] =  "虛幻魔女";
    AtlasLoot_TableNames["KaraOperaEvent"][1] =  "歌劇事件";
    AtlasLoot_TableNames["KaraCurator"][1] =  "監護者";
    AtlasLoot_TableNames["KaraIllhoof"][1] =  "泰瑞斯提安·疫蹄";
    AtlasLoot_TableNames["KaraAran"][1] =  "艾蘭之影";
    AtlasLoot_TableNames["KaraNetherspite"][1] =  "尼德斯";
    AtlasLoot_TableNames["KaraNightbane"][1] =  "夜禍";
    AtlasLoot_TableNames["KaraChess"][1] =  "西洋棋事件";
    AtlasLoot_TableNames["KaraPrince"][1] =  "瑪克薩王子";
    AtlasLoot_TableNames["KaraTrash"][1] =  "小怪 (卡拉贊)";
  --Maraudon
    AtlasLoot_TableNames["MaraNamelesProphet"][1] =  "無名預言者";
    AtlasLoot_TableNames["MaraKhanKolk"][1] =  "考爾克 (第一可汗)";
    AtlasLoot_TableNames["MaraKhanGelk"][1] =  "吉爾克 (第二可汗)";
    AtlasLoot_TableNames["MaraKhanMagra"][1] =  "瑪格拉 (第三可汗)";
    AtlasLoot_TableNames["MaraKhanVeng"][1] =  "溫格 (第五可汗)";
    AtlasLoot_TableNames["MaraNoxxion"][1] =  "諾克賽恩";
    AtlasLoot_TableNames["MaraRazorlash"][1] =  "銳刺鞭笞者";
    AtlasLoot_TableNames["MaraKhanMaraudos"][1] =  "瑪拉多斯 (第四可汗)";
    AtlasLoot_TableNames["MaraLordVyletongue"][1] =  "維利塔恩";
    AtlasLoot_TableNames["MaraMeshlok"][1] =  "收割者麥什洛克";
    AtlasLoot_TableNames["MaraCelebras"][1] =  "被詛咒的塞雷布拉斯";
    AtlasLoot_TableNames["MaraLandslide"][1] =  "蘭斯利德";
    AtlasLoot_TableNames["MaraTinkererGizlock"][1] =  "工匠吉茲洛克";
    AtlasLoot_TableNames["MaraRotgrip"][1] =  "洛特格里普";
    AtlasLoot_TableNames["MaraPrincessTheradras"][1] =  "瑟萊德絲公主";
  --Molten Core
    AtlasLoot_TableNames["MCLucifron"][1] =  "魯西弗隆";
    AtlasLoot_TableNames["MCMagmadar"][1] =  "瑪格曼達";
    AtlasLoot_TableNames["MCGehennas"][1] =  "基赫納斯";
    AtlasLoot_TableNames["MCGarr"][1] =  "加爾";
    AtlasLoot_TableNames["MCShazzrah"][1] =  "沙斯拉爾";
    AtlasLoot_TableNames["MCGeddon"][1] =  "迦頓男爵";
    AtlasLoot_TableNames["MCGolemagg"][1] =  "焚化者古雷曼格";
    AtlasLoot_TableNames["MCSulfuron"][1] =  "薩弗隆先驅者";
    AtlasLoot_TableNames["MCMajordomo"][1] =  "管理者埃克索圖斯";
    AtlasLoot_TableNames["MCRagnaros"][1] =  "拉格納羅斯";
    AtlasLoot_TableNames["MCRANDOMBOSSDROPPS"][1] =  "首領隨機掉落";
    AtlasLoot_TableNames["MCTrashMobs"][1] =  "小怪";
  --Naxxramas
    AtlasLoot_TableNames["NAXPatchwerk"][1] =  "縫補者";
    AtlasLoot_TableNames["NAXGrobbulus"][1] =  "葛羅巴斯";
    AtlasLoot_TableNames["NAXGluth"][1] =  "古魯斯";
    AtlasLoot_TableNames["NAXThaddius"][1] =  "泰迪斯";
    AtlasLoot_TableNames["NAXAnubRekhan"][1] =  "阿努比瑞克漢";
    AtlasLoot_TableNames["NAXGrandWidowFaerlina"][1] =  "大寡婦費琳娜";
    AtlasLoot_TableNames["NAXMaexxna"][1] =  "梅克絲娜";
    AtlasLoot_TableNames["NAXInstructorRazuvious"][1] =  "講師拉祖維斯";
    AtlasLoot_TableNames["NAXGothikderHarvester"][1] =  "收割者高希";
    AtlasLoot_TableNames["NAXTheFourHorsemen"][1] =  "四騎士";
    AtlasLoot_TableNames["NAXNothderPlaguebringer"][1] =  "瘟疫者諾斯";
    AtlasLoot_TableNames["NAXHeiganderUnclean"][1] =  "骯髒者海根";
    AtlasLoot_TableNames["NAXLoatheb"][1] =  "洛斯伯";
    AtlasLoot_TableNames["NAXSapphiron"][1] =  "薩菲隆";
    AtlasLoot_TableNames["NAXKelThuzard"][1] =  "科爾蘇加德";
    AtlasLoot_TableNames["NAXTrash"][1] =  "小怪 (納克薩瑪斯)";
  --Onyxia's Lair
    AtlasLoot_TableNames["Onyxia"][1] =  "奧妮克希亞";
  --Ragefire Chasm
    AtlasLoot_TableNames["RFCTaragaman"][1] =  "饑餓者塔拉加曼";
    AtlasLoot_TableNames["RFCJergosh"][1] =  "祈求者耶戈什";
  --Razorfen Downs
    AtlasLoot_TableNames["RFDTutenkash"][1] =  "圖特卡什";
    AtlasLoot_TableNames["RFDHenryStern"][1] =  "亨利·斯特恩";
    AtlasLoot_TableNames["RFDMordreshFireEye"][1] =  "火眼莫德雷斯";
    AtlasLoot_TableNames["RFDGlutton"][1] =  "暴食者";
    AtlasLoot_TableNames["RFDRagglesnout"][1] =  "拉戈斯諾特";
    AtlasLoot_TableNames["RFDAmnennar"][1] =  "寒冰之王亞門納爾";
    AtlasLoot_TableNames["RFDPlaguemaw"][1] =  "腐爛的普雷莫爾";
    AtlasLoot_TableNames["RFDTrash"][1] =  "小怪 (剃刀高地)";
  --Razorfen Kraul
    AtlasLoot_TableNames["RFKThorncurse"][1] =  "阿格姆";
    AtlasLoot_TableNames["RFKDeathSpeakerJargba"][1] =  "亡語者賈格巴";
    AtlasLoot_TableNames["RFKOverlordRamtusk"][1] =  "主宰拉姆塔斯";
    AtlasLoot_TableNames["RFKAgathelos"][1] =  "暴怒的阿迦賽羅斯";
    AtlasLoot_TableNames["RFKBlindHunter"][1] =  "盲眼獵手";
    AtlasLoot_TableNames["RFKCharlgaRazorflank"][1] =  "卡爾加·刺肋";
    AtlasLoot_TableNames["RFKEarthcallerHalmgar"][1] =  "喚地者哈穆加";
    AtlasLoot_TableNames["RFKRoogug"][1] =  "魯古格";
    AtlasLoot_TableNames["RFKTrash"][1] =  "小怪 (剃刀沼澤)";
  --The Ruins of Ahn'Qiraj
    AtlasLoot_TableNames["AQ20Kurinnaxx"][1] =  "庫林納克斯";
    AtlasLoot_TableNames["AQ20Andorov"][1] =  "安多洛夫中將";
    AtlasLoot_TableNames["AQ20CAPTIAN"][1] =  "拉賈克斯的上尉們";
    AtlasLoot_TableNames["AQ20Rajaxx"][1] =  "拉賈克斯將軍";
    AtlasLoot_TableNames["AQ20Moam"][1] =  "莫阿姆";
    AtlasLoot_TableNames["AQ20Buru"][1] =  "吞咽者布魯";
    AtlasLoot_TableNames["AQ20Ayamiss"][1] =  "狩獵者阿亞米斯";
    AtlasLoot_TableNames["AQ20Ossirian"][1] =  "無疤者奧斯里安";
    AtlasLoot_TableNames["AQ20Trash"][1] =  "小怪 (AQ20)";
    AtlasLoot_TableNames["AQ20ClassBooks"][1] =  "AQ 職業書籍";
    AtlasLoot_TableNames["AQEnchants"][1] =  "AQ 公式";
  --Scarlet Monestery - Armory
    AtlasLoot_TableNames["SMHerod"][1] =  "赫洛德";
    AtlasLoot_TableNames["SMTrash"][1] =  "小怪 (修道院)";
  --Scarlet Monestery - Cathedral
    AtlasLoot_TableNames["SMFairbanks"][1] =  "大檢察官法爾班克斯";
    AtlasLoot_TableNames["SMMograine"][1] =  "血色十字軍指揮官莫格萊尼";
    AtlasLoot_TableNames["SMWhitemane"][1] =  "大檢察官懷特邁恩";
  --Scarlet Monestery - Graveyard
    AtlasLoot_TableNames["SMVishas"][1] =  "審訊員韋沙斯";
    AtlasLoot_TableNames["SMIronspine"][1] =  "鐵脊死靈";
    AtlasLoot_TableNames["SMAzshir"][1] =  "永醒的艾希爾";
    AtlasLoot_TableNames["SMFallenChampion"][1] =  "死靈勇士";
    AtlasLoot_TableNames["SMBloodmageThalnos"][1] =  "血法師薩爾諾斯";
  --Scarlet Monestery - Library
    AtlasLoot_TableNames["SMHoundmasterLoksey"][1] =  "馴犬者洛克希";
    AtlasLoot_TableNames["SMDoan"][1] =  "祕法師杜安";
  --Scholomance
    AtlasLoot_TableNames["SCHOLOBloodStewardofKirtonos"][1] =  "基爾圖諾斯的衛士";
    AtlasLoot_TableNames["SCHOLOKirtonostheHerald"][1] =  "傳令官基爾圖諾斯";
    AtlasLoot_TableNames["SCHOLOJandiceBarov"][1] =  "詹迪斯·巴羅夫";
    AtlasLoot_TableNames["SCHOLORattlegore"][1] =  "血骨傀儡";
    AtlasLoot_TableNames["SCHOLODeathKnight"][1] =  "死亡騎士達克雷爾";
    AtlasLoot_TableNames["SCHOLOMarduk"][1] =  "馬杜克·布萊克波爾";
    AtlasLoot_TableNames["SCHOLOVectus"][1] =  "維克圖斯";
    AtlasLoot_TableNames["SCHOLORasFrostwhisper"][1] =  "萊斯·霜語";
    AtlasLoot_TableNames["SCHOLOKormok"][1] =  "科爾莫克 (召喚)";
    AtlasLoot_TableNames["SCHOLOInstructorMalicia"][1] =  "講師瑪麗希亞";
    AtlasLoot_TableNames["SCHOLODoctorTheolenKrastinov"][1] =  "瑟爾林·卡斯迪諾夫教授";
    AtlasLoot_TableNames["SCHOLOLorekeeperPolkelt"][1] =  "博學者普克爾特";
    AtlasLoot_TableNames["SCHOLOTheRavenian"][1] =  "拉文尼亞";
    AtlasLoot_TableNames["SCHOLOLordAlexeiBarov"][1] =  "阿萊克斯·巴羅夫";
    AtlasLoot_TableNames["SCHOLOLadyIlluciaBarov"][1] =  "伊露希亞·巴羅夫";
    AtlasLoot_TableNames["SCHOLODarkmasterGandling"][1] =  "黑暗院長加丁";
    AtlasLoot_TableNames["SCHOLOQuestItems"][1] =  "任務物品 (通靈)";
    AtlasLoot_TableNames["SCHOLOTrash"][1] =  "小怪 (通靈)";
  --Shadowfang Keep
    AtlasLoot_TableNames["BSFRazorclawtheButcher"][1] =  "屠夫拉佐克勞";
    AtlasLoot_TableNames["BSFSilverlaine"][1] =  "席瓦萊恩男爵";
    AtlasLoot_TableNames["BSFSpringvale"][1] =  "指揮官斯普林瓦爾";
    AtlasLoot_TableNames["BSFOdotheBlindwatcher"][1] =  "盲眼守衛奧杜";
    AtlasLoot_TableNames["BSFFenrustheDevourer"][1] =  "吞噬者芬魯斯";
    AtlasLoot_TableNames["BSFWolfMasterNandos"][1] =  "狼王南杜斯";
  
    AtlasLoot_TableNames["BSFArchmageArugal"][1] =  "大法師阿魯高";
    AtlasLoot_TableNames["BSFDeathswornCaptain"][1] =  "死亡誓言者隊長";
    AtlasLoot_TableNames["BSFFelSteed"][1] =  "地獄戰馬";
    AtlasLoot_TableNames["BSFRethilgore"][1] =  "雷希戈爾";
    AtlasLoot_TableNames["BSFTrash"][1] =  "小怪 (影牙)";
  --The Stockade
    AtlasLoot_TableNames["SWStTargor"][1] =  "可怕的塔高爾";
    AtlasLoot_TableNames["SWStKamDeepfury"][1] =  "卡姆·深怒";
    AtlasLoot_TableNames["SWStBazilThredd"][1] =  "巴基爾·斯瑞德";
    AtlasLoot_TableNames["SWStDextrenWard"][1] =  "迪克斯特·瓦德";
    AtlasLoot_TableNames["SWStBruegalIronknuckle"][1] =  "布魯戈·艾爾克納寇";
  --Stratholme
    AtlasLoot_TableNames["STRATSkull"][1] =  "斯庫爾";
    AtlasLoot_TableNames["STRATStratholmeCourier"][1] =  "郵箱鑰匙";
    AtlasLoot_TableNames["STRATFrasSiabi"][1] =  "弗拉斯·希亞比";
    AtlasLoot_TableNames["STRATAtiesh"][1] =  "阿泰絲 <薩格拉斯之手>";
    AtlasLoot_TableNames["STRATHearthsingerForresten"][1] =  "弗雷斯特恩";
    AtlasLoot_TableNames["STRATTheUnforgiven"][1] =  "不可寬恕者";
    AtlasLoot_TableNames["STRATTimmytheCruel"][1] =  "悲慘的提米";
    AtlasLoot_TableNames["STRATMalorsStrongbox"][1] =  "瑪洛爾的箱子";
    AtlasLoot_TableNames["STRATCrimsonHammersmith"][1] =  "紅衣鑄錘師 (召喚)";
    AtlasLoot_TableNames["STRATBSPlansSerenity"][1] =  "設計圖:平靜";
    AtlasLoot_TableNames["STRATCannonMasterWilley"][1] =  "炮手威利";
    AtlasLoot_TableNames["STRATArchivistGalford"][1] =  "檔案管理員加爾福特";
    AtlasLoot_TableNames["STRATBalnazzar"][1] =  "巴納札爾";
    AtlasLoot_TableNames["STRATSothosJarien"][1] =  "索索斯及賈林";
    AtlasLoot_TableNames["STRATStonespine"][1] =  "石脊";
    AtlasLoot_TableNames["STRATNerubenkan"][1] =  "奈魯布恩坎";
    AtlasLoot_TableNames["STRATBaronessAnastari"][1] =  "安娜絲塔麗男爵夫人";
    AtlasLoot_TableNames["STRATBlackGuardSwordsmith"][1] =  "黑衣守衛鑄劍師 (召喚)";
    AtlasLoot_TableNames["STRATBSPlansCorruption"][1] =  "設計圖:腐蝕";
    AtlasLoot_TableNames["STRATMalekithePallid"][1] =  "蒼白的瑪勒基";
    AtlasLoot_TableNames["STRATMagistrateBarthilas"][1] =  "巴瑟拉斯鎮長";
    AtlasLoot_TableNames["STRATRamsteintheGorger"][1] =  "吞嚥者拉姆斯登";
    AtlasLoot_TableNames["STRATBaronRivendare"][1] =  "瑞文戴爾男爵";
    AtlasLoot_TableNames["STRATTrash"][1] =  "小怪 (斯坦)";
  --Sunken Temple
    AtlasLoot_TableNames["STSpawnOfHakkar"][1] =  "哈卡的後代";
    AtlasLoot_TableNames["STTrollMinibosses"][1] =  "食人妖小首領";
    AtlasLoot_TableNames["STAtalalarion"][1] =  "阿塔拉利恩";
    AtlasLoot_TableNames["STDreamscythe"][1] =  "德姆塞卡爾";
    AtlasLoot_TableNames["STWeaver"][1] =  "德拉維沃爾";

    AtlasLoot_TableNames["STAvatarofHakkar"][1] =  "哈卡的化身";
    AtlasLoot_TableNames["STJammalan"][1] =  "預言者迦瑪蘭";
    AtlasLoot_TableNames["STOgom"][1] =  "可悲的奧戈姆";
    AtlasLoot_TableNames["STMorphaz"][1] =  "摩弗拉斯";
    AtlasLoot_TableNames["STHazzas"][1] =  "哈札斯";
    AtlasLoot_TableNames["STEranikus"][1] =  "伊蘭尼庫斯的陰影";
    AtlasLoot_TableNames["STTrash"][1] =  "小怪 (斯坦)";
  --Temple of Ahn'Qiraj
    AtlasLoot_TableNames["AQ40Skeram"][1] =  "預言者斯克拉姆";
    AtlasLoot_TableNames["AQ40Vem"][1] =  "蟲族";
    AtlasLoot_TableNames["AQ40Sartura"][1] =  "沙爾圖拉";
    AtlasLoot_TableNames["AQ40Fankriss"][1] =  "頑強的范克里斯";
    AtlasLoot_TableNames["AQ40Viscidus"][1] =  "維希度斯";
    AtlasLoot_TableNames["AQ40Huhuran"][1] =  "哈霍蘭公主";
    AtlasLoot_TableNames["AQ40Emperors"][1] =  "雙子帝王";
    AtlasLoot_TableNames["AQ40Ouro"][1] =  "奧羅";
    AtlasLoot_TableNames["AQ40CThun"][1] =  "克蘇恩";
    AtlasLoot_TableNames["AQ40Trash1"][1] =  "小怪 (AQ40)";
    AtlasLoot_TableNames["AQ40Trash2"][1] =  "小怪 (AQ40)";
    AtlasLoot_TableNames["AQOpening"][1] =  "安其拉開門系列任務";
  --TK: The Arcatraz
    AtlasLoot_TableNames["TKArcUnbound"][1] =  "無約束的希瑞奇斯";
    AtlasLoot_TableNames["TKArcUnboundHEROIC"][1] =  "無約束的希瑞奇斯 (英雄)";
    AtlasLoot_TableNames["TKArcDalliah"][1] =  "末日預言者達利亞";
    AtlasLoot_TableNames["TKArcDalliahHEROIC"][1] =  "末日預言者達利亞 (英雄)";
    AtlasLoot_TableNames["TKArcScryer"][1] =  "怒鐮者索扣斯瑞特";
    AtlasLoot_TableNames["TKArcScryerHEROIC"][1] =  "怒鐮者索扣斯瑞特 (英雄)";
    AtlasLoot_TableNames["TKArcHarbinger"][1] =  "先驅者史蓋力司";
    AtlasLoot_TableNames["TKArcHarbingerHEROIC"][1] =  "先驅者史蓋力司 (英雄)";
    AtlasLoot_TableNames["TKArcTrash"][1] =  "小怪 (風暴:亞克崔茲)";
  --TK: The Botanica
    AtlasLoot_TableNames["TKBotSarannis"][1] =  "指揮官薩瑞尼斯";
    AtlasLoot_TableNames["TKBotSarannisHEROIC"][1] =  "指揮官薩瑞尼斯 (英雄)";
    AtlasLoot_TableNames["TKBotFreywinn"][1] =  "大植物學家費瑞衛恩";
    AtlasLoot_TableNames["TKBotFreywinnHEROIC"][1] =  "大植物學家費瑞衛恩 (英雄)";
    AtlasLoot_TableNames["TKBotThorngrin"][1] =  "看管者索古林";
    AtlasLoot_TableNames["TKBotThorngrinHEROIC"][1] =  "看管者索古林 (英雄)";
    AtlasLoot_TableNames["TKBotLaj"][1] =  "拉杰";
    AtlasLoot_TableNames["TKBotLajHEROIC"][1] =  "拉杰 (英雄)";
    AtlasLoot_TableNames["TKBotSplinter"][1] =  "扭曲分裂者";
    AtlasLoot_TableNames["TKBotSplinterHEROIC"][1] =  "扭曲分裂者 (英雄)";
    AtlasLoot_TableNames["TKBotTrash"][1] =  "小怪 (風暴:波塔尼卡)";
  --TK: The Eye
    AtlasLoot_TableNames["TKEyeAlar"][1] =  "歐爾";
    AtlasLoot_TableNames["TKEyeVoidReaver"][1] =  "虛空劫掠者";
    AtlasLoot_TableNames["TKEyeSolarian"][1] =  "高階星術師索拉瑞恩";
    AtlasLoot_TableNames["TKEyeKaelthas"][1] =  "凱爾薩斯·逐日者";
    AtlasLoot_TableNames["TKEyeLegendaries"][1] =  "凱爾薩斯·逐日者史詩物品";
    AtlasLoot_TableNames["TKEyeTrash"][1] =  "小怪 (風暴:暴風之眼)";
  --TK: The Mechanar
    AtlasLoot_TableNames["TKMechGyro"][1] =  "看守者蓋洛奇歐";
    AtlasLoot_TableNames["TKMechGyroHEROIC"][1] =  "看守者蓋洛奇歐 (英雄)";
    AtlasLoot_TableNames["TKMechIron"][1] =  "看守者鐵手";
    AtlasLoot_TableNames["TKMechIronHEROIC"][1] =  "看守者鐵手 (英雄)";
    AtlasLoot_TableNames["TKMechCacheoftheLegion"][1] =  "軍團儲藏處";
    AtlasLoot_TableNames["TKMechCapacitus"][1] =  "機械王卡帕希特斯";
    AtlasLoot_TableNames["TKMechCapacitusHEROIC"][1] =  "機械王卡帕希特斯 (英雄)";
    AtlasLoot_TableNames["TKMechSepethrea"][1] =  "虛空術師賽派斯瑞";
    AtlasLoot_TableNames["TKMechSepethreaHEROIC"][1] =  "虛空術師賽派斯瑞 (英雄)";
    AtlasLoot_TableNames["TKMechCalc"][1] =  "計算者帕薩里歐";
    AtlasLoot_TableNames["TKMechCalcHEROIC"][1] =  "計算者帕薩里歐 (英雄)";
    AtlasLoot_TableNames["TKMechTrash"][1] =  "小怪 (風暴:麥克那爾)";
  --Uldaman
    AtlasLoot_TableNames["UldRevelosh"][1] =  "魯維羅什";
    AtlasLoot_TableNames["UldBaelog"][1] =  "巴爾洛戈";
    AtlasLoot_TableNames["UldIronaya"][1] =  "艾隆納亞";
    AtlasLoot_TableNames["UldAncientStoneKeeper"][1] =  "古代的石頭看守者";
    AtlasLoot_TableNames["UldGalgannFirehammer"][1] =  "加加恩·火錘";
    AtlasLoot_TableNames["UldGrimlok"][1] =  "格瑞姆洛克";
    AtlasLoot_TableNames["UldArchaedas"][1] =  "阿札達斯";
    AtlasLoot_TableNames["UldTrash"][1] =  "小怪 (奧達曼)";
  --Wailing Caverns
    AtlasLoot_TableNames["WCLordCobrahn"][1] =  "考布萊恩";
    AtlasLoot_TableNames["WCLadyAnacondra"][1] =  "安娜科德拉";
    AtlasLoot_TableNames["WCKresh"][1] =  "克雷什";
    AtlasLoot_TableNames["WCLordPythas"][1] =  "皮薩斯";
    AtlasLoot_TableNames["WCSkum"][1] =  "斯卡姆";
    AtlasLoot_TableNames["WCLordSerpentis"][1] =  "瑟芬迪斯";
    AtlasLoot_TableNames["WCVerdan"][1] =  "永生者沃爾丹";
    AtlasLoot_TableNames["WCMutanus"][1] =  "吞噬者穆坦努斯";
    AtlasLoot_TableNames["WCDeviateFaerieDragon"][1] =  "變異精靈龍";
  --Zul'Aman
    AtlasLoot_TableNames["ZANalorakk"][1] =  "Nalorakk";
    AtlasLoot_TableNames["ZAJanAlai"][1] =  "Jan'Alai";
    AtlasLoot_TableNames["ZAAkilZon"][1] =  "Akil'Zon";
    AtlasLoot_TableNames["ZAHalazzi"][1] =  "Halazzi";
    AtlasLoot_TableNames["ZAJinZakk"][1] =  "Hexxlord Jin'Zakk";
    AtlasLoot_TableNames["ZAZuljin"][1] =  "Zul'jin";
  --Zul'Farrak
    AtlasLoot_TableNames["ZFAntusul"][1] =  "安圖蘇爾";
    AtlasLoot_TableNames["ZFThekatheMartyr"][1] =  "殉教者塞卡";
    AtlasLoot_TableNames["ZFWitchDoctorZumrah"][1] =  "巫醫祖穆拉恩";
    AtlasLoot_TableNames["ZFNekrumGutchewer"][1] =  "耐克魯姆";
    AtlasLoot_TableNames["ZFSezzziz"][1] =  "暗影祭司塞瑟斯";
    AtlasLoot_TableNames["ZFDustwraith"][1] =  "灰塵怨靈";
    AtlasLoot_TableNames["ZFSergeantBly"][1] =  "布萊中士";
    AtlasLoot_TableNames["ZFSandfury"][1] =  "沙怒劊子手";
    AtlasLoot_TableNames["ZFHydromancerVelratha"][1] =  "水占師維蕾薩";
    AtlasLoot_TableNames["ZFGahzrilla"][1] =  "加茲瑞拉";
    AtlasLoot_TableNames["ZFChiefUkorzSandscalp"][1] =  "烏克茲·沙頂";
    AtlasLoot_TableNames["ZFZerillis"][1] =  "澤雷利斯";
    AtlasLoot_TableNames["ZFTrash"][1] =  "小怪 (ZF)";
  --Zul'Gurub
    AtlasLoot_TableNames["ZGJeklik"][1] =  "高階祭司耶克里克";
    AtlasLoot_TableNames["ZGVenoxis"][1] =  "高階祭司溫諾希斯";
    AtlasLoot_TableNames["ZGMarli"][1] =  "哈卡萊安魂者";
    AtlasLoot_TableNames["ZGMandokir"][1] =  "血領主曼多基爾";
    AtlasLoot_TableNames["ZGGrilek"][1] =  "格里雷克";
    AtlasLoot_TableNames["ZGHazzarah"][1] =  "哈札拉爾";
    AtlasLoot_TableNames["ZGRenataki"][1] =  "雷納塔基";
    AtlasLoot_TableNames["ZGWushoolay"][1] =  "烏蘇雷";
    AtlasLoot_TableNames["ZGGahzranka"][1] =  "加茲蘭卡";
    AtlasLoot_TableNames["ZGThekal"][1] =  "古拉巴什食腐者";
    AtlasLoot_TableNames["ZGArlokk"][1] =  "哈卡萊先知";
    AtlasLoot_TableNames["ZGJindo"][1] =  "妖術師金度";
    AtlasLoot_TableNames["ZGHakkar"][1] =  "哈卡";
    AtlasLoot_TableNames["ZGShared"][1] =  "ZG首領隨機掉落";
    AtlasLoot_TableNames["ZGTrash1"][1] =  "小怪 (ZG)";
    AtlasLoot_TableNames["ZGTrash2"][1] =  "小怪 (ZG)";
    AtlasLoot_TableNames["ZGEnchants"][1] =  "ZG 公式";
  --Arena PvP Sets, Season 1
    AtlasLoot_TableNames["ArenaDruid"][1] =  "德魯伊競技場套裝";
    AtlasLoot_TableNames["ArenaHunter"][1] =  "獵人競技場套裝";
    AtlasLoot_TableNames["ArenaMage"][1] =  "法師競技場套裝";
    AtlasLoot_TableNames["ArenaPaladin"][1] =  "聖騎士競技場套裝";
    AtlasLoot_TableNames["ArenaPriest"][1] =  "牧師競技場套裝";
    AtlasLoot_TableNames["ArenaRogue"][1] =  "盜賊競技場套裝";
    AtlasLoot_TableNames["ArenaShaman"][1] =  "薩滿競技場套裝";
    AtlasLoot_TableNames["ArenaWarlock"][1] =  "術士競技場套裝";
    AtlasLoot_TableNames["ArenaWarrior"][1] =  "戰士競技場套裝";
  --Arena PvP Sets, Season 2
    AtlasLoot_TableNames["Arena2Druid"][1] =  "德魯伊競技場套裝";
    AtlasLoot_TableNames["Arena2Hunter"][1] =  "獵人競技場套裝";
    AtlasLoot_TableNames["Arena2Mage"][1] =  "法師競技場套裝";
    AtlasLoot_TableNames["Arena2Paladin"][1] =  "聖騎士競技場套裝";
    AtlasLoot_TableNames["Arena2Priest"][1] =  "牧師競技場套裝";
    AtlasLoot_TableNames["Arena2Rogue"][1] =  "盜賊競技場套裝";
    AtlasLoot_TableNames["Arena2Shaman"][1] =  "薩滿競技場套裝";
    AtlasLoot_TableNames["Arena2Warlock"][1] =  "術士競技場套裝";
    AtlasLoot_TableNames["Arena2Warrior"][1] =  "戰士競技場套裝";
  --Level 60 PvP Sets
    AtlasLoot_TableNames["PVPDruid"][1] =  "德魯伊PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPHunter"][1] =  "獵人PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPMage"][1] =  "法師PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPPaladin"][1] =  "聖騎士PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPPriest"][1] =  "牧師PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPRogue"][1] =  "盜賊PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPShaman"][1] =  "薩滿PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPWarlock"][1] =  "術士PvP套裝 (60級)";
    AtlasLoot_TableNames["PVPWarrior"][1] =  "戰士PvP套裝 (60級)";
  --Level 70 PvP Sets
    AtlasLoot_TableNames["PVP70Druid1"][1] =  "德魯伊PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Druid2"][1] =  "德魯伊PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Hunter"][1] =  "獵人PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Mage"][1] =  "法師PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Paladin1"][1] =  "聖騎士PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Paladin2"][1] =  "聖騎士PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Priest"][1] =  "牧師PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Rogue"][1] =  "盜賊PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Shaman1"][1] =  "薩滿PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Shaman2"][1] =  "薩滿PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Warlock"][1] =  "術士PvP套裝 (70級)";
    AtlasLoot_TableNames["PVP70Warrior"][1] =  "戰士PvP套裝 (70級)";
  --Pre60 Sets
    AtlasLoot_TableNames["DEADMINES"][1] =  "迪菲亞皮甲";
    AtlasLoot_TableNames["WAILING"][1] =  "毒蛇的擁抱";
    AtlasLoot_TableNames["SCARLET"][1] =  "血色十字軍鏈甲";
    AtlasLoot_TableNames["BLACKROCKD"][1] =  "角鬥士套裝";
    AtlasLoot_TableNames["IRONWEAVE"][1] =  "鐵織戰裝";
    AtlasLoot_TableNames["ScholoCloth"][1] =  "骨堆套裝";
    AtlasLoot_TableNames["ScholoLeather"][1] =  "蒼白套裝";
    AtlasLoot_TableNames["ScholoMail"][1] =  "血鏈套裝";
    AtlasLoot_TableNames["ScholoPlate"][1] =  "亡骨守護者";
    AtlasLoot_TableNames["STRAT"][1] =  "郵差套裝";
    AtlasLoot_TableNames["ScourgeInvasion"][1] =  "天譴軍團";
    AtlasLoot_TableNames["ShardOfGods"][1] =  "天神碎片";
    AtlasLoot_TableNames["ZGRings"][1] =  "祖爾格拉布套戒";
    AtlasLoot_TableNames["SpiritofEskhandar"][1] =  "艾斯卡達爾之魂";
    AtlasLoot_TableNames["HakkariBlades"][1] =  "哈卡萊雙刃";
    AtlasLoot_TableNames["PrimalBlessing"][1] =  "原始祝福";
    AtlasLoot_TableNames["DalRend"][1] =  "雷德雙刀";
    AtlasLoot_TableNames["SpiderKiss"][1] =  "蜘蛛之吻";
  --BC Sets
    AtlasLoot_TableNames["TwinStars"][1] =  "雙子星套裝";
    AtlasLoot_TableNames["AzzinothBlades"][1] =  "埃辛諾斯雙刃";
  --Crafted Sets - Blacksmithing
    AtlasLoot_TableNames["ImperialPlate"][1] =  "君王鎧甲";
    AtlasLoot_TableNames["TheDarksoul"][1] =  "黑暗之魂";
    AtlasLoot_TableNames["FelIronPlate"][1] =  "魔鐵鎧甲";
    AtlasLoot_TableNames["AdamantiteB"][1] =  "堅鋼戰甲";
    AtlasLoot_TableNames["FlameG"][1] =  "烈焰套裝";
    AtlasLoot_TableNames["EnchantedAdaman"][1] =  "附魔堅鋼護甲";
    AtlasLoot_TableNames["KhoriumWard"][1] =  "克銀結界";
    AtlasLoot_TableNames["FaithFelsteel"][1] =  "信仰魔鋼";
    AtlasLoot_TableNames["BurningRage"][1] =  "燃燒狂怒";
    AtlasLoot_TableNames["BloodsoulEmbrace"][1] =  "血魂的擁抱";
    AtlasLoot_TableNames["FelIronChain"][1] =  "魔鐵鍊甲";
  --Crafted Sets - Tailoring
    AtlasLoot_TableNames["BloodvineG"][1] =  "血藤之服";
    AtlasLoot_TableNames["NeatherVest"][1] =  "幽紋套裝";
    AtlasLoot_TableNames["ImbuedNeather"][1] =  "韌化幽紋套裝";
    AtlasLoot_TableNames["ArcanoVest"][1] =  "奧紋套裝";
    AtlasLoot_TableNames["TheUnyielding"][1] =  "頑強套裝";
    AtlasLoot_TableNames["WhitemendWis"][1] =  "白癒智慧";
    AtlasLoot_TableNames["SpellstrikeInfu"][1] =  "法擊套裝";
    AtlasLoot_TableNames["BattlecastG"][1] =  "戰放服裝";
    AtlasLoot_TableNames["SoulclothEm"][1] =  "靈魂布的擁抱";
    AtlasLoot_TableNames["PrimalMoon"][1] =  "原始月布";
    AtlasLoot_TableNames["ShadowEmbrace"][1] =  "暗影的擁抱";
    AtlasLoot_TableNames["SpellfireWrath"][1] =  "魔焰之怒";
  --Crafted Sets - Leatherworking
    AtlasLoot_TableNames["VolcanicArmor"][1] =  "火山護甲";
    AtlasLoot_TableNames["IronfeatherArmor"][1] =  "鐵羽護甲";
    AtlasLoot_TableNames["StormshroudArmor"][1] =  "雷暴護甲";
    AtlasLoot_TableNames["DevilsaurArmor"][1] =  "魔暴龍護甲";
    AtlasLoot_TableNames["BloodTigerH"][1] =  "血虎套索";
    AtlasLoot_TableNames["PrimalBatskin"][1] =  "原始蝙蝠皮套裝";
    AtlasLoot_TableNames["WildDraenishA"][1] =  "狂野德萊尼護甲";
    AtlasLoot_TableNames["ThickDraenicA"][1] =  "厚德萊尼護甲";
    AtlasLoot_TableNames["FelSkin"][1] =  "惡魔皮膚";
    AtlasLoot_TableNames["SClefthoof"][1] =  "裂蹄力量";
    AtlasLoot_TableNames["GreenDragonM"][1] =  "綠龍鎖甲";
    AtlasLoot_TableNames["BlueDragonM"][1] =  "藍龍鎖甲";
    AtlasLoot_TableNames["BlackDragonM"][1] =  "黑龍鎖甲";
    AtlasLoot_TableNames["ScaledDraenicA"][1] =  "德萊尼鱗護甲";
    AtlasLoot_TableNames["FelscaleArmor"][1] =  "魔鱗護甲";
    AtlasLoot_TableNames["FelstalkerArmor"][1] =  "惡魔捕獵者套裝";
    AtlasLoot_TableNames["NetherFury"][1] =  "虛空之怒套裝";
    AtlasLoot_TableNames["PrimalIntent"][1] =  "原始之意套裝";
    AtlasLoot_TableNames["WindhawkArmor"][1] =  "風之隼護甲";
    AtlasLoot_TableNames["NetherscaleArmor"][1] =  "地獄鱗護甲";
    AtlasLoot_TableNames["NetherstrikeArmor"][1] =  "地擊套裝";
  --ZG Sets
    AtlasLoot_TableNames["ZGDruid"][1] =  "德魯伊ZG套裝";
    AtlasLoot_TableNames["ZGHunter"][1] =  "獵人ZG套裝";
    AtlasLoot_TableNames["ZGMage"][1] =  "法師ZG套裝";
    AtlasLoot_TableNames["ZGPaladin"][1] =  "聖騎士ZG套裝";
    AtlasLoot_TableNames["ZGPriest"][1] =  "牧師ZG套裝";
    AtlasLoot_TableNames["ZGRogue"][1] =  "盜賊ZG套裝";
    AtlasLoot_TableNames["ZGShaman"][1] =  "薩滿ZG套裝";
    AtlasLoot_TableNames["ZGWarlock"][1] =  "術士ZG套裝";
    AtlasLoot_TableNames["ZGWarrior"][1] =  "戰士ZG套裝";
  --AQ20 Sets
    AtlasLoot_TableNames["AQ20Druid"][1] =  "德魯伊RAQ套裝";
    AtlasLoot_TableNames["AQ20Hunter"][1] =  "獵人RAQ套裝";
    AtlasLoot_TableNames["AQ20Mage"][1] =  "法師RAQ套裝";
    AtlasLoot_TableNames["AQ20Paladin"][1] =  "聖騎士RAQ套裝";
    AtlasLoot_TableNames["AQ20Priest"][1] =  "牧師RAQ套裝";
    AtlasLoot_TableNames["AQ20Rogue"][1] =  "盜賊RAQ套裝";
    AtlasLoot_TableNames["AQ20Shaman"][1] =  "薩滿RAQ套裝";
    AtlasLoot_TableNames["AQ20Warlock"][1] =  "術士RAQ套裝";
    AtlasLoot_TableNames["AQ20Warrior"][1] =  "戰士RAQ套裝";
  --AQ40 Sets
    AtlasLoot_TableNames["AQ40Druid"][1] =  "德魯伊TAQ套裝";
    AtlasLoot_TableNames["AQ40Emperors"][1] =  "雙子帝王";
    AtlasLoot_TableNames["AQ40Fankriss"][1] =  "頑強的范克里斯";
    AtlasLoot_TableNames["AQ40Huhuran"][1] =  "哈霍蘭公主";
    AtlasLoot_TableNames["AQ40Hunter"][1] =  "獵人TAQ套裝";
    AtlasLoot_TableNames["AQ40Mage"][1] =  "法師TAQ套裝";
    AtlasLoot_TableNames["AQ40Paladin"][1] =  "聖騎士TAQ套裝";
    AtlasLoot_TableNames["AQ40Priest"][1] =  "牧師TAQ套裝";
    AtlasLoot_TableNames["AQ40Rogue"][1] =  "盜賊TAQ套裝";
    AtlasLoot_TableNames["AQ40Shaman"][1] =  "薩滿TAQ套裝";
    AtlasLoot_TableNames["AQ40Warlock"][1] =  "術士TAQ套裝";
    AtlasLoot_TableNames["AQ40Warrior"][1] =  "戰士TAQ套裝";
  --Dungeon Set 1/2
    AtlasLoot_TableNames["T0Druid"][1] =  "德魯伊副本套裝 1-2";
    AtlasLoot_TableNames["T0Hunter"][1] =  "獵人副本套裝 1-2";
    AtlasLoot_TableNames["T0Mage"][1] =  "法師副本套裝 1-2";
    AtlasLoot_TableNames["T0Paladin"][1] =  "聖騎士副本套裝 1-2";
    AtlasLoot_TableNames["T0Priest"][1] =  "牧師副本套裝 1-2";
    AtlasLoot_TableNames["T0Rogue"][1] =  "盜賊副本套裝 1-2";
    AtlasLoot_TableNames["T0Shaman"][1] =  "薩滿副本套裝 1-2";
    AtlasLoot_TableNames["T0Warlock"][1] =  "術士副本套裝 1-2";
    AtlasLoot_TableNames["T0Warrior"][1] =  "戰士副本套裝 1-2";
  --Dungeon Set 3
    AtlasLoot_TableNames["DS3Hallowed"][1] =  "神聖儀祭衣飾套裝 (布甲)";
    AtlasLoot_TableNames["DS3Incanter"][1] =  "魔法使的外衣套裝 (布甲)";
    AtlasLoot_TableNames["DS3Mana"][1] =  "法力蝕刻戰衣套裝 (布甲)";
    AtlasLoot_TableNames["DS3Oblivion"][1] =  "失落戰衣套裝 (布甲)";
    AtlasLoot_TableNames["DS3Assassin"][1] =  "暗殺套裝 (皮甲)";
    AtlasLoot_TableNames["DS3Moonglade"][1] =  "月光林地套裝 (皮甲)";
    AtlasLoot_TableNames["DS3Wastewalker"][1] =  "荒行套裝 (皮甲)";
    AtlasLoot_TableNames["DS3Beast"][1] =  "野獸之王護甲 (鎖甲)";
    AtlasLoot_TableNames["DS3Desolation"][1] =  "哀傷之鏈套裝 (鎖甲)";
    AtlasLoot_TableNames["DS3Tidefury"][1] =  "惡潮套裝 (鎖甲)";
    AtlasLoot_TableNames["DS3Bold"][1] =  "勇猛護甲套裝 (鎧甲)";
    AtlasLoot_TableNames["DS3Doom"][1] =  "末日戰甲套裝 (鎧甲)";
    AtlasLoot_TableNames["DS3Right"][1] =  "公正護甲 (鎧甲)";
  --T1 Sets
    AtlasLoot_TableNames["T1Druid"][1] =  "德魯伊T1套裝";
    AtlasLoot_TableNames["T1Hunter"][1] =  "獵人T1套裝";
    AtlasLoot_TableNames["T1Mage"][1] =  "法師T1套裝";
    AtlasLoot_TableNames["T1Paladin"][1] =  "聖騎士T1套裝";
    AtlasLoot_TableNames["T1Priest"][1] =  "牧師T1套裝";
    AtlasLoot_TableNames["T1Rogue"][1] =  "盜賊T1套裝";
    AtlasLoot_TableNames["T1Shaman"][1] =  "薩滿T1套裝";
    AtlasLoot_TableNames["T1Warlock"][1] =  "術士T1套裝";
    AtlasLoot_TableNames["T1Warrior"][1] =  "戰士T1套裝";
  --T2 Sets
    AtlasLoot_TableNames["T2Druid"][1] =  "德魯伊T2套裝";
    AtlasLoot_TableNames["T2Hunter"][1] =  "獵人T2套裝";
    AtlasLoot_TableNames["T2Mage"][1] =  "法師T2套裝";
    AtlasLoot_TableNames["T2Paladin"][1] =  "聖騎士T2套裝";
    AtlasLoot_TableNames["T2Priest"][1] =  "牧師T2套裝";
    AtlasLoot_TableNames["T2Rogue"][1] =  "盜賊T2套裝";
    AtlasLoot_TableNames["T2Shaman"][1] =  "薩滿T2套裝";
    AtlasLoot_TableNames["T2Warlock"][1] =  "術士T2套裝";
    AtlasLoot_TableNames["T2Warrior"][1] =  "戰士T2套裝";
  --T3 Sets
    AtlasLoot_TableNames["T3Druid"][1] =  "德魯伊T3套裝";
    AtlasLoot_TableNames["T3Hunter"][1] =  "獵人T3套裝";
    AtlasLoot_TableNames["T3Mage"][1] =  "法師T3套裝";
    AtlasLoot_TableNames["T3Paladin"][1] =  "聖騎士T3套裝";
    AtlasLoot_TableNames["T3Priest"][1] =  "牧師T3套裝";
    AtlasLoot_TableNames["T3Rogue"][1] =  "盜賊T3套裝";
    AtlasLoot_TableNames["T3Shaman"][1] =  "薩滿T3套裝";
    AtlasLoot_TableNames["T3Warlock"][1] =  "術士T3套裝";
    AtlasLoot_TableNames["T3Warrior"][1] =  "戰士T3套裝";
  --T4 Sets
    AtlasLoot_TableNames["T4Druid"][1] =  "德魯伊T4套裝";
    AtlasLoot_TableNames["T4Hunter"][1] =  "獵人T4套裝";
    AtlasLoot_TableNames["T4Mage"][1] =  "法師T4套裝";
    AtlasLoot_TableNames["T4Paladin"][1] =  "聖騎士T4套裝";
    AtlasLoot_TableNames["T4Priest"][1] =  "牧師T4套裝";
    AtlasLoot_TableNames["T4Rogue"][1] =  "盜賊T4套裝";
    AtlasLoot_TableNames["T4Shaman"][1] =  "薩滿T4套裝";
    AtlasLoot_TableNames["T4Warlock"][1] =  "術士T4套裝";
    AtlasLoot_TableNames["T4Warrior"][1] =  "戰士T4套裝";
  --T5 Sets
    AtlasLoot_TableNames["T5Druid"][1] =  "德魯伊T5套裝";
    AtlasLoot_TableNames["T5Hunter"][1] =  "獵人T5套裝";
    AtlasLoot_TableNames["T5Mage"][1] =  "法師T5套裝";
    AtlasLoot_TableNames["T5Paladin"][1] =  "聖騎士T5套裝";
    AtlasLoot_TableNames["T5Priest"][1] =  "牧師T5套裝";
    AtlasLoot_TableNames["T5Rogue"][1] =  "盜賊T5套裝";
    AtlasLoot_TableNames["T5Shaman"][1] =  "薩滿T5套裝";
    AtlasLoot_TableNames["T5Warlock"][1] =  "術士T5套裝";
    AtlasLoot_TableNames["T5Warrior"][1] =  "戰士T5套裝";
  --T6 Sets
    AtlasLoot_TableNames["T6Druid"][1] =  "德魯伊T6套裝";
    AtlasLoot_TableNames["T6Hunter"][1] =  "獵人T6套裝";
    AtlasLoot_TableNames["T6Mage"][1] =  "法師T6套裝";
    AtlasLoot_TableNames["T6Paladin"][1] =  "聖騎士T6套裝";
    AtlasLoot_TableNames["T6Priest"][1] =  "牧師T6套裝";
    AtlasLoot_TableNames["T6Rogue"][1] =  "盜賊T6套裝";
    AtlasLoot_TableNames["T6Shaman"][1] =  "薩滿T6套裝";
    AtlasLoot_TableNames["T6Warlock"][1] =  "術士T6套裝";
    AtlasLoot_TableNames["T6Warrior"][1] =  "戰士T6套裝";
  --Misc Sets
    AtlasLoot_TableNames["CraftedWeapons1"][1] =  "鍛造史詩武器";
    AtlasLoot_TableNames["CraftedWeapons2"][1] =  "鍛造史詩武器";
    AtlasLoot_TableNames["HardModeToken"][1] =  "70級副本獎勵: 配件";
    AtlasLoot_TableNames["HardModeToken2"][1] =  "70級副本獎勵: 火抗裝備";
    AtlasLoot_TableNames["HardModeToken3"][1] =  "70級副本獎勵: 裝備與武器";
    AtlasLoot_TableNames["Legendaries"][1] =  "傳說物品";
    AtlasLoot_TableNames["RareMounts"][1] =  "稀有坐騎";
    AtlasLoot_TableNames["Tabards1"][1] =  "大衣/軍服";
    AtlasLoot_TableNames["Tabards2"][1] =  "大衣/軍服";
    AtlasLoot_TableNames["CardGame1"][1] =  "Upper Deck 卡片遊戲物品";
  --Azuregos
    AtlasLoot_TableNames["AAzuregos"][1] =  "艾索雷葛斯";
  --Doom Lord Kazzak
    AtlasLoot_TableNames["DoomLordKazzak"][1] =  "毀滅之王卡札克";
  --Doomwalker
    AtlasLoot_TableNames["DDoomwalker"][1] =  "厄運行者";
  --Emrald Dragons
    AtlasLoot_TableNames["DEmeriss"][1] =  "艾莫莉絲";
    AtlasLoot_TableNames["DLethon"][1] =  "雷索";
    AtlasLoot_TableNames["DTaerar"][1] =  "泰拉爾";
    AtlasLoot_TableNames["DYsondre"][1] =  "伊索德雷";
  --Highlord Kruul
    AtlasLoot_TableNames["KKruul"][1] =  "卡魯歐領主";
  --Aldor
    AtlasLoot_TableNames["Aldor1"][1] =  "奧多爾: 友善/尊敬";
    AtlasLoot_TableNames["Aldor2"][1] =  "奧多爾: 崇敬/崇拜";
  --The Argent Dawn
    AtlasLoot_TableNames["Argent1"][1] =  "銀色黎明: 徽記兌換";
    AtlasLoot_TableNames["Argent2"][1] =  "銀色黎明";
  --Ashtongue Deathsworn
    AtlasLoot_TableNames["Ashtongue1"][1] =  "灰舌死亡誓言者";
    AtlasLoot_TableNames["Ashtongue2"][1] =  "灰舌死亡誓言者";
  --The Bloodsail Buccaneers
    AtlasLoot_TableNames["Bloodsail1"][1] =  "血帆海盜";
  --The Brood of Nozdormu
    AtlasLoot_TableNames["AQBroodRings"][1] =  "諾茲多姆的子嗣";
  --The Cenarion Circle
    AtlasLoot_TableNames["Cenarion1"][1] =  "塞納里奧議會: 友善";
    AtlasLoot_TableNames["Cenarion2"][1] =  "塞納里奧議會: 尊敬";
    AtlasLoot_TableNames["Cenarion3"][1] =  "塞納里奧議會: 崇敬";
    AtlasLoot_TableNames["Cenarion4"][1] =  "塞納里奧議會: 崇拜";
  --The Cenarion Expedition
    AtlasLoot_TableNames["CExpedition1"][1] =  "塞納里奧遠征隊: 友善/尊敬";
    AtlasLoot_TableNames["CExpedition2"][1] =  "塞納里奧遠征隊: 崇敬/崇拜";
  --The Consortium
    AtlasLoot_TableNames["Consortium1"][1] =  "聯合團: 友善/尊敬";
    AtlasLoot_TableNames["Consortium2"][1] =  "聯合團: 崇敬/崇拜";
  --The Darkmoon Faire
    AtlasLoot_TableNames["Darkmoon1"][1] =  "暗月馬戲團";
    AtlasLoot_TableNames["Darkmoon2"][1] =  "暗月馬戲團 - 飾品";
  --The Frostwolf Clan
    AtlasLoot_TableNames["Frostwolf1"][1] =  "霜狼氏族";
  --The Hydraxian Waterlords
    AtlasLoot_TableNames["WaterLords1"][1] =  "海達希亞水元素";
  --Gelkis Clan Centaur
    AtlasLoot_TableNames["GelkisClan1"][1] =  "吉爾吉斯半人馬";
  --Honor Hold
    AtlasLoot_TableNames["HonorHold1"][1] =  "榮譽堡: 友善/尊敬";
    AtlasLoot_TableNames["HonorHold2"][1] =  "榮譽堡: 崇敬/崇拜";
  --The Keepers of Time
    AtlasLoot_TableNames["KeepersofTime1"][1] =  "時光守望者";
  --The Kurenai
    AtlasLoot_TableNames["Kurenai1"][1] =  "卡爾奈";
  --Lower City
    AtlasLoot_TableNames["LowerCity1"][1] =  "陰鬱城";
  --The Mag'har
    AtlasLoot_TableNames["Maghar1"][1] =  "瑪格哈";
  --Magram Clan Centaur
    AtlasLoot_TableNames["MagramClan1"][1] =  "瑪格拉姆半人馬";
  --Netherwing
    AtlasLoot_TableNames["Netherwing1"][1] =  "虛空之翼";
  --Ogri'la
    AtlasLoot_TableNames["Ogrila1"][1] =  "歐格利拉";
  --The Scale of the Sands
    AtlasLoot_TableNames["ScaleSands1"][1] =  "流沙之鱗";
    AtlasLoot_TableNames["ScaleSands2"][1] =  "流沙之鱗";
  --The Scryers
    AtlasLoot_TableNames["Scryer1"][1] =  "占卜者: 友善/尊敬";
    AtlasLoot_TableNames["Scryer2"][1] =  "占卜者: 崇敬/崇拜";
  --The Sha'tar
    AtlasLoot_TableNames["Shatar1"][1] =  "薩塔";
  --Sha'tari Skyguard
    AtlasLoot_TableNames["Skyguard1"][1] =  "薩塔禦天者";
  --The Sporeggar
    AtlasLoot_TableNames["Sporeggar1"][1] =  "斯博格爾";
  --The Stormpike Guard
    AtlasLoot_TableNames["Stormpike1"][1] =  "雷矛衛隊";
  --The Thorium Brotherhood
    AtlasLoot_TableNames["Thorium1"][1] =  "瑟銀兄弟會: 友善/尊敬";
    AtlasLoot_TableNames["Thorium2"][1] =  "瑟銀兄弟會: 崇敬/崇拜";
  --Thrallmar
    AtlasLoot_TableNames["Thrallmar1"][1] =  "索爾瑪: 友善/尊敬";
    AtlasLoot_TableNames["Thrallmar2"][1] =  "索爾瑪: 崇敬/崇拜";
  --Timbermaw Hold
    AtlasLoot_TableNames["Timbermaw"][1] =  "木喉要塞";
  --The Tranquillien
    AtlasLoot_TableNames["Tranquillien1"][1] =  "安寧地";
  --The Violet Eye
    AtlasLoot_TableNames["VioletEye1"][1] =  "紫羅蘭之眼";
  --The Wintersaber Trainers
    AtlasLoot_TableNames["Wintersaber1"][1] =  "冬刃豹訓練師";
  --The Zandalar Tribe
    AtlasLoot_TableNames["Zandalar1"][1] =  "贊達拉部族: 友善/尊敬";
    AtlasLoot_TableNames["Zandalar2"][1] =  "贊達拉部族: 崇敬/崇拜";
  --Battlegrounds
    AtlasLoot_TableNames["ABMisc"][1] =  "阿拉希盆地雜項獎勵";
    AtlasLoot_TableNames["ABBlue"][1] =  "阿拉希盆地精良獎勵";
    AtlasLoot_TableNames["ABPurple"][1] =  "阿拉希盆地史詩獎勵";
    AtlasLoot_TableNames["ABSets1"][1] =  "阿拉希盆地套裝（布甲/皮甲）";
    AtlasLoot_TableNames["ABSets2"][1] =  "阿拉希盆地套裝（鎖甲/鎧甲）";
    AtlasLoot_TableNames["AVMisc"][1] =  "奧特蘭克山谷雜項獎勵";
    AtlasLoot_TableNames["AVBlue"][1] =  "奧特蘭克山谷精良獎勵";
    AtlasLoot_TableNames["AVPurple"][1] =  "奧特蘭克山谷史詩獎勵";
    AtlasLoot_TableNames["WSGMisc"][1] =  "戰歌峽谷雜項獎勵";
    AtlasLoot_TableNames["WSGBlue"][1] =  "戰歌峽谷精良獎勵";
    AtlasLoot_TableNames["WSGPurple"][1] =  "戰歌峽谷史詩獎勵";
  --World PvP
    AtlasLoot_TableNames["Hellfire"][1] =  "地域火半島: 防禦堡壘";
    AtlasLoot_TableNames["Nagrand1"][1] =  "納葛蘭: 哈剌";
    AtlasLoot_TableNames["Nagrand2"][1] =  "納葛蘭: 哈剌";
    AtlasLoot_TableNames["Terokkar"][1] =  "泰洛卡森林: 精神哨塔";
    AtlasLoot_TableNames["Zangarmarsh"][1] =  "贊格沼澤: 雙塔廢墟";
  --Misc Other PvP
    AtlasLoot_TableNames["PvP60Accessories1"][1] =  "PvP 配件 (60級)";
    AtlasLoot_TableNames["PvP60Accessories2"][1] =  "PvP 配件 - 聯盟 (等級60)";
    AtlasLoot_TableNames["PvP60Accessories3"][1] =  "PvP 配件 - 部落 (等級60)";
    AtlasLoot_TableNames["PvP70Accessories1"][1] =  "PvP 配件 (70級)";
    AtlasLoot_TableNames["PvP70Accessories2"][1] =  "PvP 配件 (70級)";
    AtlasLoot_TableNames["PvP70NonSet1"][1] =  "PvP 非套裝史詩配件";
    AtlasLoot_TableNames["PvP70NonSet2"][1] =  "PvP 非套裝史詩布甲";
    AtlasLoot_TableNames["PvP70NonSet3"][1] =  "PvP 非套裝史詩皮甲";
    AtlasLoot_TableNames["PvP70NonSet4"][1] =  "PvP 非套裝史詩鎖甲";
    AtlasLoot_TableNames["PvP70NonSet5"][1] =  "PvP 非套裝史詩鎧甲";
    AtlasLoot_TableNames["PVPWeapons1"][1] =  "60級 PvP 武器";
    AtlasLoot_TableNames["PVPWeapons2"][1] =  "60級 PvP 武器";
    AtlasLoot_TableNames["PVP70Weapons1"][1] =  "70級 PvP 武器";
    AtlasLoot_TableNames["PVP70Weapons2"][1] =  "70級 PvP 武器";
    AtlasLoot_TableNames["ArenaWeapons"][1] =  "競技場第一季聯賽-武器";
    AtlasLoot_TableNames["Arena2Weapons"][1] =  "競技場第二季聯賽-武器";
  --Menus, the entry does nothing, but makes the generalised loot table code less complex
    AtlasLoot_TableNames["AQ40SET"][1] =  "dummy";
    AtlasLoot_TableNames["AQ20SET"][1] =  "dummy";
    AtlasLoot_TableNames["ZGSET"][1] =  "dummy";
    AtlasLoot_TableNames["PRE60SET"][1] =  "dummy";
    AtlasLoot_TableNames["CRAFTSET"][1] =  "dummy";
    AtlasLoot_TableNames["CRAFTSET2"][1] =  "dummy";
    AtlasLoot_TableNames["T6SET"][1] =  "dummy";
    AtlasLoot_TableNames["T5SET"][1] =  "dummy";
    AtlasLoot_TableNames["T4SET"][1] =  "dummy";
    AtlasLoot_TableNames["T3SET"][1] =  "dummy";
    AtlasLoot_TableNames["T2SET"][1] =  "dummy";
    AtlasLoot_TableNames["T1SET"][1] =  "dummy";
    AtlasLoot_TableNames["T0SET"][1] =  "dummy";
    AtlasLoot_TableNames["DS3SET"][1] =  "dummy";
    AtlasLoot_TableNames["PVPSET"][1] =  "dummy";
    AtlasLoot_TableNames["PVP70SET"][1] =  "dummy";
    AtlasLoot_TableNames["PVP70NONSETEPICS"][1] =  "dummy";
    AtlasLoot_TableNames["ARENASET"][1] =  "dummy";
    AtlasLoot_TableNames["ARENA2SET"][1] =  "dummy";
    AtlasLoot_TableNames["REPMENU_AZEROTHPREBC"][1] =  "dummy";
    AtlasLoot_TableNames["REPMENU_AZEROTHPOSTBC"][1] =  "dummy";
    AtlasLoot_TableNames["REPMENU_OUTLAND"][1] =  "dummy";
    AtlasLoot_TableNames["REPMENU_SHATTRATH"][1] =  "dummy";
    AtlasLoot_TableNames["REPMENU"][1] =  "dummy";
  --If all else fails!
    AtlasLoot_TableNames["EmptyInstance"][1] =  "AtlasLoot";
end